<?php require 'includes/header.php'; ?>

<main class="main">

  <!-- Page Title -->
  <div class="page-title" data-aos="fade">
    <div class="container">
      <nav class="breadcrumbs">
        <ol>
          <li><a href="index.php">Home</a></li>
          <li class="current">About</li>
          <li class="current">About Pedicon 2026</li>
          <li class="current">Invitation</li>
          <li class="current">Letter from Chairperson, Scientific Committee</li>
        </ol>
      </nav>
    </div>
  </div>

  <section id="contact" class="contact section">
    <div class="container sub-header-titel aos-init aos-animate" data-aos="fade-up">
      <h2>Letter from Chairperson, Scientific Committee</h2>
    </div>

    <div class="container" data-aos="fade-up" data-aos-delay="100">

      <div class="row gy-4">
        <div class="col-lg-12">
          <p>
            <b>Dear Esteemed Colleagues,</b><br><br>
            It is an honor to invite you to PEDICON 2026, the 63rd Annual Conference of the Indian
            Academy of Pediatrics, to be held in January 2026 in Kolkata, India.<br><br>
            As the Chairman of the Scientific Committee, I am excited to share our plans for an
            extraordinary academic program. With 10 parallel halls running simultaneously, PEDICON
            2026 will be a hub of intellectual energy, offering something for every delegate, from frontline
            clinicians to academic researchers.<br><br>
            The theme, “Caring for Every Child: Shaping the Future Together,” reflects our commitment
            to advancing pediatric care. The program will feature keynote addresses from global leaders,
            interactive workshops, thematic symposia, and opportunities to present groundbreaking
            research. Subspecialty tracks will ensure deep dives into focused areas, while hands-on
            sessions will allow practical skill enhancement.<br><br>
            This year’s scientific agenda is designed to provide cutting-edge insights and foster
            meaningful discussions that will drive the future of pediatrics. Whether you are looking to
            update your knowledge, connect with peers, or gain new perspectives, PEDICON 2026 will
            exceed your expectations.<br><br>
            Kolkata, with its unique blend of heritage and innovation, serves as a fitting venue for this
            grand event. Beyond academic pursuits, the city’s charm and warmth will leave you inspired
            and energized.<br><br>
            I look forward to welcoming you to PEDICON 2026, where knowledge meets purpose and
            innovation meets impact. Together, let’s shape the future of pediatrics.<br><br>
          </p>
        </div>
      </div>

      <div class="row"> 
        
        <div class="col-md-6">
        <p>Regards,</p>
          <p>
             
            <b>Dr Kripasindhu Chatterjee<br>
            Chairperson, Scientific Committee<br>
            PEDICON 2026</b>
          </p>
        </div>

        <div class="col-md-6">
          <p>
            <br>
            <b>Dr Dibyendu Raychaudhari<br>
            Chairperson, Scientific Committee<br>
            PEDICON 2026</b>
          </p>
        </div>
      </div>
    </div>

  </section><!-- /Contact Section -->

</main>

<?php require 'includes/footer.php'; ?>
